﻿using System;
using System.IO;
using System.Net;
using System.Net.Sockets;
using System.Text;

class MoneyClient
{
    static void Main()
    {
        const int StreamSize = 256;
        const int Port = 2010;
        const string LocalHost = "localhost";
        var ipEndPt = new IPEndPoint(
            new IPAddress(
                new byte[] { 127, 0, 0, 1 }),
            Port);
        var AsciiEnc = new ASCIIEncoding();
        var inStream = new byte[StreamSize];
        var outStream = new byte[StreamSize];

        string freeAdvice;
        string choice = "W";

        do
        {
            try
            {
                Console.WriteLine("\nDoradca finansowy\n");
                Console.WriteLine("1 - Otrzymanie wskazówki");
                Console.WriteLine("W - Wyjście z programu");
                Console.Write("\nWybierz opcję:  ");
                choice = Console.ReadLine();
                Console.WriteLine();

                var myClient = new TcpClient(LocalHost, Port);
                Stream myStream = myClient.GetStream();

                outStream = AsciiEnc.GetBytes(
                    "Podaj sekret na zbicie fortuny:");

                if (choice == "1")
                {
                    // wysłanie żądania do serwera
                    myStream.Write(
                        outStream, 0, outStream.Length);

                    // usunięcie zbędnych danych z tablicy typu byte
                    for (int i = 0; i < inStream.Length; i++)
                    {
                        inStream[i] = 0;
                    }

                    // odczyt odpowiedzi serwera
                    myStream.Read(
                        inStream, 0, inStream.Length);
                    freeAdvice = AsciiEnc.GetString(
                        inStream, 0, inStream.Length);
                    Console.WriteLine("Odpowiedź serwera: {0}",
                                       freeAdvice);
                }
                else
                {
                    // zamknięcie sesji
                    outStream = AsciiEnc.GetBytes("bye");
                    myStream.Write(
                        outStream, 0, outStream.Length);
                }
            }
            catch (InvalidOperationException ioe)
            {
                Console.WriteLine(
                   "Komunikat błędu nieprawidłowej operacji: {0}",
                    ioe.Message);
            }
            catch (Exception e)
            {
                Console.WriteLine(
                    "Komunikat błędu: {0}",
                     e.Message);
            }
        } while (choice == "1");
    }
}
